# etsi sanoja, jotka päättyvät etunimeen

# kussakin ensimmäisiä etunimiä, yksi/rivi
NAME_FILES = (
    "mieseka.txt",    # vähintään 100 miehellä
    "naineneka.txt",  # vähintään 100 naisella
)

# suomen kielen sanalista, yksi/rivi
WORD_FILE = "kotus-singles.txt"

# sanoja, jotka eivät saa päätyä tuloksiin
WORD_BLOCKLIST = frozenset((
    # etnisyys
    "hottentotti", "inkkari", "manne", "murjaani",
    # päihteet
    "dokata", "humputella", "kaljoitella", "narkkari", "nuuskata",
    "pultsari", "rillutella",
    # seksi
    "hepsankeikka", "huoritella", "naida", "naiskennella", "narttu",
    "paneskella", "panna", "paritella",
    "rakastella", "runkata", "runkkari",
    "vilautella", "viuhahdella", "vokotella",
    # lika, ruumis, terveys, sairaus
    "absessi", "avanne", "flimmeri",
    "hemofilia", "hilse", "hypertensio",
    "kakata", "kikkare", "kuseskella",
    "lirautella", "oksennella", "peppu",
    # väkivalta, itsensä vahingoittaminen
    "itsari", "murhaava", "pedofilia", "raadella", "raiskata",
    # muut herjat
    "hikari", "kaheli", "kommari", "nuljaska", "pelle",
))

# lyhin ja pisin huomioitava nimi
MIN_NAME_LEN = 4
MAX_NAME_LEN = 99

def read_lines(filename):
    # generoi ei-tyhjät rivit, ilman tyhjämerkkejä alussa ja lopussa

    with open(filename, "rt") as handle:
        handle.seek(0)
        for line in handle:
            line = line.rstrip()
            if line:
                yield line

def main():
    print("Sanoja, jotka päättyvät etunimeen")

    # lue nimet
    names = set()
    for filename in NAME_FILES:
        for name in read_lines(filename):
            name = name.lower()
            if name.isalpha() and MIN_NAME_LEN <= len(name) <= MAX_NAME_LEN:
                names.add(name)
    print("Nimiä luettu:", len(names))

    # lue sanat
    words = set()
    for word in read_lines(WORD_FILE):
        word = word.lower()
        if (
            word.isalpha()
            and len(word) > MIN_NAME_LEN
            and word not in WORD_BLOCKLIST
        ):
            words.add(word)
    print("Sanoja luettu:", len(words))
    print()

    names = sorted(names)
    words = sorted(words)

    for word in words:
        for name in names:
            if len(name) < len(word) and word.endswith(name):
                print(word[:len(word)-len(name)].title() + "-" + name.title())

main()
